<?php

class WebImage
{
  public $gdresource;
  public $type;

  // Zwolnienie zasobw
  public function __destruct()
  {
    if ($this->gdresource)
    {
      imagedestroy($this->gdresource);
    }
  }


  // adowanie obrazka z pliku
  public function load($file)
  {
    // Pobranie typu MIME obrazka
    $size = getimagesize($file);
    $this->type = $size['mime'];

    // adowanie obrazka na podstawie typu
    switch ($this->type)
    {
      case 'image/jpeg':
        $this->gdresource = imagecreatefromjpeg($file);
        break;
      case 'image/png':
        $this->gdresource = imagecreatefrompng($file);
        break;
      case 'image/gif':
        $this->gdresource = imagecreatefromgif($file);
        break;
    }

    // Zachowujemy informacje o kanale alfa
    imagesavealpha($this->gdresource, true);
  }


  // Zapisanie pliku na lokalnym komputerze
  public function save($file)
  {
    switch ($this->type)
    {
      case 'image/jpeg':
        imagejpeg($this->gdresource, $file);
        break;
      case 'image/png':
        imagepng($this->gdresource, $file);
        break;
      case 'image/gif':
        // Konwersja do palety
        if (imageistruecolor($this->gdresource))
        {
          imagetruecolortopalette($this->gdresource, false, 256);
        }
        imagegif($this->gdresource, $file);
        break;
    }
  }


  // Wywietlenie obrazka w przegldarce
  public function display()
  {
    switch ($this->type)
    {
      case 'image/jpeg':
        header("Content-type: image/jpeg");
        imagejpeg($this->gdresource);
        break;
      case 'image/png':
        header("Content-type: image/png");
        imagepng($this->gdresource);
        break;
      case 'image/gif':
        // Konwersja do palety
        if (imageistruecolor($this->gdresource))
        {
          imagetruecolortopalette($this->gdresource, false, 256);
        }
        header("Content-type: image/gif");
        imagegif($this->gdresource);
        break;
    }
  }

}

  // Zmiana wymiarw obrazka
  public function resize()
  {
    require_once 'class.ImageResize.php';

    $ir = new ImageResize();

    // Parametry zmiany obrazu ustalamy na podstawie przekazanych danych
    switch (func_num_args())
    {
      case 1:
        $ir->ratio = func_get_arg(0);
        break;
      case 2:
        $ir->max_width = func_get_arg(0);
        $ir->max_height = func_get_arg(1);
        break;
    }

    // Wykonanie zmiany rozmiaru
    $this->gdresource = $ir->process($this->gdresource);
  }

  // Obrt obrazka
  public function rotate($degrees)
  {
    require_once 'class.ImageRotate.php';

    $ir = new ImageRotate();
        
    // Ustalenie parametrw obrotu
    $ir->rotation = $degrees;

    // Wykonanie obrotu
    $this->gdresource = $ir->process($this->gdresource);
  }

  // Dodanie podpisu do obrazka
  public function caption($text, 
                          $font, 
                          $size = null, 
                          $padding = null, 
                          $drawline = null)
  {
    require_once 'class.ImageCaption.php';

    $ic = new ImageCaption();

    // Ustalenie rozmiaru, dopenienia i ewentualnej linii
    if ($size)
    {
      $ic->fontsize = $size;
    }
    if ($padding !== null)
    {
      $ic->padding = $padding;
    }
    if ($drawline !== null)
    {
      $ic->drawline = $drawline;
    }
        
    // Ustalenie czcionki i tekstu podpisu
    $ic->fontfile = $font;
    $ic->caption = $text;
        
    // Wstawienie podpisu na obrazek
    $this->gdresource = $ic->process($this->gdresource);
  }

  public function logo($logofile,
                       $loc_x = null,
                       $loc_y = null,
                       $padding = null,
                       $ratio = null)
  {
    require_once 'class.ImageLogo.php';

    $il = new ImageLogo();

    // Plik logo
    $il->logofile = $logofile;
    
    // Lokalizacja, dopenienie i powikszenie
    if ($loc_x !== null)
    {
      $il->location['x'] = $loc_x;
    }
    if ($loc_y !== null)
    {
      $il->location['y'] = $loc_y;
    }
    if ($padding !== null)
    {
      $il->padding = $padding;
    }
    if ($ratio !== null)
    {
      $il->ratio = $ratio;
    }

    // Wstawienie logo na obrazek
    $this->gdresource = $il->process($this->gdresource);
  }

?>
